!===============================================================================
! CVS $Id: shr_sys_mod.F90,v 1.4 2001/02/23 19:02:48 tcraig Exp $
! CVS $Source: /fs/cgd/csm/models/CVS.REPOS/shared/csm_share/shr_sys_mod.F90,v $
! CVS $Name: csim4_3_0 $
!===============================================================================

MODULE sys_column

   integer,parameter :: SHR_KIND_IN = kind(1)                ! native integer

CONTAINS

!===============================================================================
SUBROUTINE shr_sys_flush(unit)

   implicit none

   !----- arguments -----
   integer(SHR_KIND_IN) :: unit  ! flush output buffer for this unit

!-------------------------------------------------------------------------------
! PURPOSE: an architecture independant system call
!-------------------------------------------------------------------------------

#if (defined IRIX64 || defined CRAY || defined OSF1 || defined Linux)
   call flush(unit)
#endif

#if (defined AIX)
   call flush_(unit)
#endif

#if (!defined CRAY && !defined IRIX64 && !defined AIX && !defined OSF1 && !defined Linux)
   write(*,*) '(shr_sys_flush) ERROR: no implementation for this architecture'
   stop
#endif

END SUBROUTINE shr_sys_flush

!===============================================================================

END MODULE sys_column

