c $Id: $
c=======================================================================
!---! Main driving routine for Single Column Version of
!---! Community Climate System Model Sea Ice Component
!---! Version 2.0
!---!
!---! author C. M. Bitz
c=======================================================================

#ifdef ice_only
      program dummy_driver
      use ice_calendar
      use ice_coupling

      implicit none

c  files begin on day 295 (Oct 22)
      open(15,file='userdata/currydata_oct22.dat'
     &          ,form='formatted',STATUS= 'UNKNOWN' )
c      open(10,file='userdata/open_clos_oct22.dat'
c     &          ,form='formatted',STATUS= 'UNKNOWN' )
      open(13,file='userdata/div_clos_oct22.dat'
     &          ,form='formatted',STATUS= 'UNKNOWN' )
      open(16,file='userdata/zenith_oct22.dat'
     &          ,form='formatted',STATUS= 'UNKNOWN' )

      call initialize_column_sea_ice

      !-----------------------------------------------------------------
      ! timestep loop 
      !-----------------------------------------------------------------
      stop_now = 0

      do while (stop_now .lt. 1)

        istep  = istep  + 1
        istep1 = istep1 + 1
        time = time + dt        ! determine the time and date
        call calendar(time)      
        call fabricate_cpl_data
        call from_coupler
        if( stop_now .eq. 1 ) goto 200 ! 
        call icemodel
        call to_coupler

      enddo ! while

 200  continue

      close(70)
      close(75)

      stop

      end program dummy_driver

c=======================================================================

      subroutine fabricate_cpl_data

      use ice_model_size
      use ice_calendar
      use ice_constants
      use ice_coupling
      use ice_ocean

      implicit none

      integer (kind=int_kind) ::
     &   i, j                      ! generic indices

      real  (kind=dbl_kind)   ::
     &   swdallband

      real (kind=dbl_kind) :: clsg1,clsg2,clsg3,clsg4 ! dummies for closing rates
      real (kind=dbl_kind) :: diverg,opng,clsg ! dummies for opening rate and divergence
     &,    dumtime ! time dummy

c Input file has closing with sign opposite to what the model expects
c Model thinks divu = open-clos, so add them here
c      read(10,*) dumtime,opng,clsg
c      diverg = opng+clsg
c four options for closing rate, first one is not recommended
      read(13,*) dumtime,diverg,clsg1,clsg,clsg3,clsg4

      do j=1,jmt_global
        do i=1,imt_global
c sst is unused by column model, sss is only used to compute freezing temp
          rbuff(i,j,kbufr_sss) = 33.5_dbl_kind
          rbuff(i,j,kbufr_sst) = Tffresh
     $         -rbuff(i,j,kbufr_sss)*depressT
c I intend for uocn to be ustar in ice_therm_driver.F 
          rbuff(i,j,kbufr_uocn) = 0.008_dbl_kind ! fab
          rbuff(i,j,kbufr_vocn) = 0.008_dbl_kind ! fab
c using the buffer variable fw for deep ocean heat flux
          rbuff(i,j,kbufr_fw) = c0                ! fab

          rbuff(i,j,kbufr_clsg) = -clsg
          rbuff(i,j,kbufr_divu) = diverg

          rbuff(i,j,kbufr_zlvl) = c10
          rbuff(i,j,kbufr_uatm) = c5
          rbuff(i,j,kbufr_vatm) = c5
          rbuff(i,j,kbufr_Tair) = 260.0_dbl_kind
          rbuff(i,j,kbufr_potT) = rbuff(i,j,kbufr_Tair)
          rbuff(i,j,kbufr_Qa) = 0.85 * 640380. /
     $         exp(5107.4/rbuff(i,j,kbufr_Tair) ) / 1.3 
          rbuff(i,j,kbufr_rhoa) = 1.3_dbl_kind 
          rbuff(i,j,kbufr_tiltx) = c0 
          rbuff(i,j,kbufr_tilty) = c0
          rbuff(i,j,kbufr_flw) = 140.0_dbl_kind
          rbuff(i,j,kbufr_rain) = c0
          rbuff(i,j,kbufr_snow) = 0.75e-5_dbl_kind
        enddo
      enddo

      do j=1,jmt_global
        do i=1,imt_global
          read(15,*) dumtime,rbuff(i,j,kbufr_uatm),
     $         rbuff(i,j,kbufr_Tair),rbuff(i,j,kbufr_Qa),
     $         rbuff(i,j,kbufr_flw), swdallband,
     $         rbuff(i,j,kbufr_snow)

! convert Qa from g/kg to kg/kg
          rbuff(i,j,kbufr_Qa)=rbuff(i,j,kbufr_Qa)*0.001  
! convert snow from mm/day to kg/m^2 s both in liquid equiv
          rbuff(i,j,kbufr_snow)=rbuff(i,j,kbufr_snow)/86400

          rbuff(i,j,kbufr_potT) = rbuff(i,j,kbufr_Tair)
          rbuff(i,j,kbufr_swdidr) = swdallband*0.29   ! 0.47
          rbuff(i,j,kbufr_swdvdr) = swdallband*0.31   ! 0.53
          rbuff(i,j,kbufr_swdidf) = swdallband*0.24
          rbuff(i,j,kbufr_swdvdf) = swdallband*0.16
        enddo
      enddo

      do j=jlo,jhi
        do i=ilo,ihi
          read(16,*) dumtime,  cosznth(i,j)  ! for ocean albedos
        enddo
      enddo
      call ocn_albedos  ! compute ocn albedos 

      end subroutine fabricate_cpl_data

c=======================================================================
#else

      subroutine icecpl(oro, ccmdt, calday, snowh, ubot, vbot, tbot  ,
     &            qbot   , thbot , zbot, pbot, flwds,
     &            sols,soll,solsd,solld,precc,precl,precsc,precsl,
     &            tssub  , cflx, wsx , wsy , ts    , 
     &            shf    , lhf   , lwup, trefoi, nlon   , 
     &            cosznext , asdir ,aldir,asdif, aldif )

c
c Coupling strategy is to stuff variables external to ice model
c into the send buffer from ice_coupling. However, I am not 
c complete consistent
c
      use ice_model_size
      use ice_calendar
      use ice_albedo
      use ice_ocean
      use ice_flux
      use ice_state
      use ice_constants
      use ice_coupling
      use ice_mechred

      implicit none

      real (kind=dbl_kind), intent(in) ::
     &      ccmdt,   
     &      calday,
     &      ubot ,   ! bot level u wind
     &      vbot ,   ! bot level v wind
     &      tbot,    ! bot level temperature (K ?)
     &      qbot,    ! bot level specific humidity (kg/kg)
     &      thbot,   ! bot level potential temperature
     &      zbot,    ! bot level height
     &      pbot,    ! bot level pressure
     &      flwds,   ! net downward longwave radiation at surface
     &      sols,    ! direct beam solar radiation onto srf (sw)
     &      soll,    ! direct beam solar radiation onto srf (lw)
     &      solsd,   ! diffuse solar radiation onto srf (sw)
     &      solld,   ! diffuse solar radiation onto srf (lw)
     &      precc,   ! convective precip rate (m h2o/s) 
     &      precl,   ! large-scale precip rate (m h2o/s) 
     &      precsc,  ! convective snow-fall rate (m h2o/s) 
     &      precsl,  ! large-scale snow-fall rate (m h2o/s) 
     &      tssub,   ! dummy
     &      cosznext ! cosine of zenith angle for next step

      integer (kind=int_kind), intent(in) ::     nlon

      real (kind=dbl_kind), intent(out) ::
     &      oro  ,   ! land/ocean/sea ice flag
     &      snowh,   ! ccm snow depth (liquid water)
     &      cflx,    ! evaporative flux (kg/m^2/s) 
     &      wsx,     ! surface u-stress (N)
     &      wsy,     ! surface v-stress (N)
     &      ts   , ! sfc temp (merged w/ocean if coupled) (K)
     &      shf  , ! sensible heat flux
     &      lhf  , ! latent heat flux
     &      lwup , ! longwave up radiative flux
     &      trefoi , ! ref height surface air temp
     &      asdir,   ! ocean + ice albedo: shortwave, direct
     &      asdif,   ! ocean + ice albedo: shortwave, diffuse
     &      aldir,   ! ocean + ice albedo: longwave, direct
     &      aldif    ! ocean + ice albedo: longwave, diffuse

      real (kind=dbl_kind) :: opng,clsg ! dummy for opening rate
     &,    dumtime ! time dummy
     &,    ccmtime ! atmosphere model time in seconds

      integer (kind=int_kind) ::  i, j

c model timing unique for coupling to ccm3.10 column model
c do not bother with using coupler buffer for now since
c it is custom job here
      ccmtime=(calday-1)*86400.
      dt = ccmdt
      time = time + dt          ! determine the time and date
      istep  = istep  + 1
      istep1 = istep1 + 1
      call calendar(time)
      if (abs(ccmtime-time).gt.c1)
     $     write(6,*) 'ICE and ATM model times do not match'

c this is a little shabby to not bother with coupler buffer 
c for cosznth -- just being lazy for now
      do j=jlo,jhi
        do i=ilo,ihi
          cosznth(i,j) = cosznext   ! for ocean albedos
        enddo
      enddo

c data file for opening and closing rates
      if (istep.eq.1)
     &     open(70,file='userdata/open_clos_oct22.dat'
     &          ,form='formatted',STATUS= 'UNKNOWN' )
      read(70,*) dumtime,opng,clsg

      do j=1,jmt_global
        do i=1,imt_global
c sst is unused by column model, sss is only used to compute freezing temp
          rbuff(i,j,kbufr_sss) = 33.5_dbl_kind    ! fab
          rbuff(i,j,kbufr_sst) = Tffresh
     $         -rbuff(i,j,kbufr_sss)*depressT
c I intend for uocn to be ustar in ice_therm_driver.F 
c see init_ocn in ice_ocean.F
          rbuff(i,j,kbufr_uocn) = 0.008_dbl_kind ! fab
          rbuff(i,j,kbufr_vocn) = 0.008_dbl_kind ! fab
c using the buffer variable fw for deep ocean heat flux
          rbuff(i,j,kbufr_fw) = c0                ! fab
c Input file has closing with sign opposite to what the model expects
c Model thinks divu = open-clos, so add them here
c Multiply by 0.5 to reduce the amplitude for now -- an ugly cludge 
          rbuff(i,j,kbufr_clsg) = -clsg
          rbuff(i,j,kbufr_divu) = (opng+clsg)
c          rbuff(i,j,kbufr_clsg) = 8.e-6_dbl_kind  ! fab
c          rbuff(i,j,kbufr_divu) = -4.e-6_dbl_kind ! fab

          rbuff(i,j,kbufr_zlvl) = zbot
          rbuff(i,j,kbufr_uatm) = ubot
          rbuff(i,j,kbufr_vatm) = vbot
          rbuff(i,j,kbufr_Tair) = tbot
          rbuff(i,j,kbufr_potT) = thbot
          rbuff(i,j,kbufr_Qa)   = qbot
          rbuff(i,j,kbufr_rhoa) = pbot/(287.04*tbot) ! pressure/(GasConst*Tair)
          rbuff(i,j,kbufr_tiltx) = c0 
          rbuff(i,j,kbufr_tilty) = c0
          rbuff(i,j,kbufr_swdidr) = soll
          rbuff(i,j,kbufr_swdvdr) = sols
          rbuff(i,j,kbufr_swdidf) = solld
          rbuff(i,j,kbufr_swdvdf) = solsd
          rbuff(i,j,kbufr_flw)  = flwds
          rbuff(i,j,kbufr_snow) = precsc+precsl
          rbuff(i,j,kbufr_rain) = precc+precl - rbuff(i,j,kbufr_snow)
          rbuff(i,j,kbufr_snow) = rbuff(i,j,kbufr_snow)*1000.0
          rbuff(i,j,kbufr_rain) = rbuff(i,j,kbufr_rain)*1000.0
        enddo
      enddo

      call from_coupler
      call icemodel

! combine ocean & ice albedos and  fluxes
      do j=jlo,jhi
        do i=ilo,ihi
          oro = 1.
          if (aice(i,j).gt.puny) oro = 2.
          asdir = alocvdr(i,j)*(1.0-aice_init(i,j))
     &             + alvdr(i,j)*aice_init(i,j)
          aldir = alocidr(i,j)*(1.0-aice_init(i,j))
     &             + alidr(i,j)*aice_init(i,j)
          asdif = alocvdf(i,j)*(1.0-aice_init(i,j))
     &             + alvdf(i,j)*aice_init(i,j)
          aldif = alocidf(i,j)*(1.0-aice_init(i,j))
     &             + alidf(i,j)*aice_init(i,j)
          lwup  = flwupoc(i,j)*(1.0-aice_init(i,j))
     &             + Flwout(i,j)*aice_init(i,j)
          shf   = fshoc(i,j)*(1.0-aice_init(i,j))
     &             + Fsensible(i,j)*aice_init(i,j)
          lhf   = flhoc(i,j)*(1.0-aice_init(i,j))
     &             + Flatent(i,j)*aice_init(i,j)
          cflx  = flhoc(i,j)/Lvap*(1.0-aice_init(i,j))
     &             + evap(i,j)*aice_init(i,j)
          wsx   = strxoc(i,j)*(1.0-aice_init(i,j))
     &             + strairxT(i,j)*aice_init(i,j)
          wsy   = stryoc(i,j)*(1.0-aice_init(i,j))
     &             + strairyT(i,j)*aice_init(i,j)
          lwup  = -lwup
          shf   = -shf
          lhf   = -lhf
          cflx  = -cflx 
          wsx   = -wsx
          wsy   = -wsy
          ts    = sst(i,j)*(1.0-aice_init(i,j)) 
     &             + Tsfc(i,j)*aice_init(i,j) + Tffresh
          trefoi = trefoc(i,j)*(1.0-aice_init(i,j))
     &             + tref(i,j)*aice_init(i,j)
          snowh  = vsno(i,j)*rhos/1000.  ! what does ccm do with this?
        enddo
      enddo

      end subroutine icecpl

c=======================================================================
#endif

      subroutine initialize_column_sea_ice

c  main driving routine for column sea ice model

      use ice_albedo
      use ice_vthermo
      use ice_mechred
      use ice_history
      use ice_coupling
      use ice_calendar
      use ice_grid
      use ice_dyn_evp
      use ice_itd
      use ice_itd_linear
      use ice_therm_driver
      use ice_init
      use ice_ocean

      implicit none

      call init_constants
      call input_data          ! namelist variables
      call init_grid           ! grid variables
      call init_calendar       ! initialize some calendar stuff
      call init_hist           ! initialize output history file
      call init_flux           ! initialize coupler fluxes
      call init_itd            ! initialize ice thickness distribution
      call init_thermo         ! initialize ice salinity and melting temp.
      call init_mechred        ! initialize ridging parameters
      call init_state          ! initialize the ice state

      if (restart) call restartfile       ! start from restart data

      call albedos             ! albedo based on initial ice distribution
      call ocn_albedos         ! ocean albedo based on zenith angle
      call calendar(time)      ! determine the initial date

      write_ic = .true.        ! write initial conditions
      call ice_write_hist
      write_ic = .false.
      istep = 0 

      end subroutine initialize_column_sea_ice

c=======================================================================

      subroutine icemodel

c  main driving routine for single column CSIM

      use ice_albedo
      use ice_vthermo
      use ice_mechred
      use ice_history
      use ice_coupling
      use ice_grid
      use ice_dyn_evp
      use ice_itd
      use ice_scaling
      use ice_itd_linear
      use ice_therm_driver
      use ice_diagnostics
      use ice_init
      use ice_ocean

      implicit none

      if (mod(istep,diagfreq).eq.0) call init_mass_diags ! diagnostic
      call init_ocn
      call thermo_rates        ! thermodynamic growth rates and fluxes
      call scale_fluxes
      call thermo_itd          ! thermodynamics and associated itd changes
      call mechanical_redistr  ! ridging
      call distr_check         ! corrections to thickness distribution
      call aggregate           ! merge categories together
      call albedos             ! compute ice albedos
      call ocn_albedos         ! compute ocn albedos (not current for ice_only)

      call scale_hist_fluxes
      if (mod(istep,diagfreq).eq.0) call runtime_diags  ! standard out
      call ice_write_hist
      if (write_restart .eq. 1) call dumpfile    ! dumps for restarting

      end subroutine icemodel

c=======================================================================

