c $Id: $
c=======================================================================
!---! Main driving routine for Single Column Version of
!---! Community Climate System Model Sea Ice Component
!---! Version 2.0
!---!
!---! author C. M. Bitz
c=======================================================================


      program dummy_driver
      use ice_calendar
      use ice_coupling

      implicit none

c  files begin on day 295 (Oct 22)
      open(15,file='userdata/currydata_oct22.dat'
     &          ,form='formatted',STATUS= 'UNKNOWN' )
c      open(10,file='userdata/open_clos_oct22.dat'
c     &          ,form='formatted',STATUS= 'UNKNOWN' )
      open(13,file='userdata/div_clos_oct22.dat'
     &          ,form='formatted',STATUS= 'UNKNOWN' )
      open(16,file='userdata/zenith_oct22.dat'
     &          ,form='formatted',STATUS= 'UNKNOWN' )

      call initialize_column_sea_ice

      !-----------------------------------------------------------------
      ! timestep loop 
      !-----------------------------------------------------------------
      stop_now = 0

      do while (stop_now .lt. 1)

        istep  = istep  + 1
        istep1 = istep1 + 1
        time = time + dt        ! determine the time and date
        call calendar(time)      
        call fabricate_cpl_data
        call from_coupler
        if( stop_now .eq. 1 ) goto 200 ! 
        call icemodel
        call to_coupler

      enddo ! while

 200  continue

      close(70)
      close(75)

      stop

      end program dummy_driver

c=======================================================================

      subroutine fabricate_cpl_data

      use ice_model_size
      use ice_calendar
      use ice_constants
      use ice_coupling
      use ice_ocean

      implicit none

      integer (kind=int_kind) ::
     &   i, j                      ! generic indices

      real  (kind=dbl_kind)   ::
     &   swdallband

      real (kind=dbl_kind) :: clsg1,clsg2,clsg3,clsg4 ! dummies for closing rates
      real (kind=dbl_kind) :: diverg,opng,clsg ! dummies for opening rate and divergence
     &,    dumtime ! time dummy

c Input file has closing with sign opposite to what the model expects
c Model thinks divu = open-clos, so add them here
c      read(10,*) dumtime,opng,clsg
c      diverg = opng+clsg
c four options for closing rate, first one is not recommended
      read(13,*) dumtime,diverg,clsg1,clsg,clsg3,clsg4

      do j=1,jmt_global
        do i=1,imt_global
c sst is unused by 1  model, sss is only used to compute freezing temp
          rbuff(i,j,kbufr_sss) = 33.5_dbl_kind
          rbuff(i,j,kbufr_sst) = Tffresh
     $         -rbuff(i,j,kbufr_sss)*depressT
c I intend for uocn to be ustar in ice_therm_driver.F 
          rbuff(i,j,kbufr_uocn) = 0.008_dbl_kind ! fab
          rbuff(i,j,kbufr_vocn) = 0.008_dbl_kind ! fab
c using the buffer variable fw for deep ocean heat flux
          rbuff(i,j,kbufr_fw) = c0                ! fab

          rbuff(i,j,kbufr_clsg) = -clsg
          rbuff(i,j,kbufr_divu) = diverg

          rbuff(i,j,kbufr_zlvl) = c10
          rbuff(i,j,kbufr_uatm) = c5
          rbuff(i,j,kbufr_vatm) = c5
          rbuff(i,j,kbufr_Tair) = 260.0_dbl_kind
          rbuff(i,j,kbufr_potT) = rbuff(i,j,kbufr_Tair)
          rbuff(i,j,kbufr_Qa) = 0.85 * 640380. /
     $         exp(5107.4/rbuff(i,j,kbufr_Tair) ) / 1.3 
          rbuff(i,j,kbufr_rhoa) = 1.3_dbl_kind 
          rbuff(i,j,kbufr_tiltx) = c0 
          rbuff(i,j,kbufr_tilty) = c0
          rbuff(i,j,kbufr_flw) = 140.0_dbl_kind
          rbuff(i,j,kbufr_rain) = c0
          rbuff(i,j,kbufr_snow) = 0.75e-5_dbl_kind
        enddo
      enddo

      do j=1,jmt_global
        do i=1,imt_global
          read(15,*) dumtime,rbuff(i,j,kbufr_uatm),
     $         rbuff(i,j,kbufr_Tair),rbuff(i,j,kbufr_Qa),
     $         rbuff(i,j,kbufr_flw), swdallband,
     $         rbuff(i,j,kbufr_snow)

! convert Qa from g/kg to kg/kg
          rbuff(i,j,kbufr_Qa)=rbuff(i,j,kbufr_Qa)*0.001  
! convert snow from mm/day to kg/m^2 s both in liquid equiv
          rbuff(i,j,kbufr_snow)=rbuff(i,j,kbufr_snow)/86400

          rbuff(i,j,kbufr_potT) = rbuff(i,j,kbufr_Tair)
          rbuff(i,j,kbufr_swdidr) = swdallband*0.29   ! 0.47
          rbuff(i,j,kbufr_swdvdr) = swdallband*0.31   ! 0.53
          rbuff(i,j,kbufr_swdidf) = swdallband*0.24
          rbuff(i,j,kbufr_swdvdf) = swdallband*0.16
        enddo
      enddo

      do j=jlo,jhi
        do i=ilo,ihi
          read(16,*) dumtime,  cosznth(i,j)  ! for ocean albedos
        enddo
      enddo
      call ocn_albedos  ! compute ocn albedos 

      end subroutine fabricate_cpl_data

c=======================================================================


      subroutine initialize_column_sea_ice

c  main driving routine for 1  sea ice model

      use ice_albedo
      use ice_vthermo
      use ice_mechred
      use ice_history
      use ice_coupling
      use ice_calendar
      use ice_grid
      use ice_dyn_evp
      use ice_itd
      use ice_itd_linear
      use ice_therm_driver
      use ice_init
      use ice_ocean

      implicit none

      call init_constants
      call input_data          ! namelist variables
      call init_grid           ! grid variables
      call init_calendar       ! initialize some calendar stuff
      call init_hist           ! initialize output history file
      call init_flux           ! initialize coupler fluxes
      call init_itd            ! initialize ice thickness distribution
      call init_thermo         ! initialize ice salinity and melting temp.
      call init_mechred        ! initialize ridging parameters
      call init_state          ! initialize the ice state

      if (restart) call restartfile       ! start from restart data

      call albedos             ! albedo based on initial ice distribution
      call ocn_albedos         ! ocean albedo based on zenith angle
      call calendar(time)      ! determine the initial date

      write_ic = .true.        ! write initial conditions
      call ice_write_hist
      write_ic = .false.
      istep = 0 

      end subroutine initialize_column_sea_ice

c=======================================================================

      subroutine icemodel

c  main driving routine for single 1  CSIM

      use ice_albedo
      use ice_vthermo
      use ice_mechred
      use ice_history
      use ice_coupling
      use ice_grid
      use ice_dyn_evp
      use ice_itd
      use ice_scaling
      use ice_itd_linear
      use ice_therm_driver
      use ice_diagnostics
      use ice_init
      use ice_ocean

      implicit none

      if (mod(istep,diagfreq).eq.0) call init_mass_diags ! diagnostic
      call init_ocn
      call thermo_rates        ! thermodynamic growth rates and fluxes
      call scale_fluxes
      call thermo_itd          ! thermodynamics and associated itd changes
      call mechanical_redistr  ! ridging
      call distr_check         ! corrections to thickness distribution
      call aggregate           ! merge categories together
      call albedos             ! compute ice albedos
      call ocn_albedos         ! compute ocn albedos (not current for 1 )

      call scale_hist_fluxes
      if (mod(istep,diagfreq).eq.0) call runtime_diags  ! standard out
      call ice_write_hist
      if (write_restart .eq. 1) call dumpfile    ! dumps for restarting

      end subroutine icemodel

c=======================================================================

